Attribute VB_Name = "modFileTime"
Option Explicit

Private Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (ByRef Destination As Any, ByRef Source As Any, ByVal numBYTEs As Long)

Private Declare Sub GetSystemTime Lib "kernel32" (lpSystemTime As SYSTEMTIME)

Private Declare Function FileTimeToSystemTime Lib "kernel32" (lpFileTime As FILETIME, lpSystemTime As SYSTEMTIME) As Long
Private Declare Function SystemTimeToFileTime Lib "kernel32" (lpSystemTime As SYSTEMTIME, lpFileTime As FILETIME) As Long

Private Declare Function FileTimeToLocalFileTime Lib "kernel32" (lpFileTime As FILETIME, lpLocalFileTime As FILETIME) As Long
Private Declare Function LocalFileTimeToFileTime Lib "kernel32" (lpLocalFileTime As FILETIME, lpFileTime As FILETIME) As Long

Public ST           As SYSTEMTIME
Public Type SYSTEMTIME
    wYear           As Integer
    wMonth          As Integer
    wDayOfWeek      As Integer
    wDay            As Integer
    wHour           As Integer
    wMinute         As Integer
    wSecond         As Integer
    wMilliseconds   As Integer
End Type

Public FT           As FILETIME
Public Type FILETIME
    dwLowDateTime   As Long
    dwHighDateTime  As Long
End Type


Public Function Get_FILETIME() As Long
    Dim lngFT As Long
    ' Format Time
    Call GetSystemTime(ST)                          ' Get Current SYSTEMTIME (GMT)
    Call SystemTimeToFileTime(ST, FT)          ' Convert SYSTEMTIME to FILETIME
    Call CopyMemory(lngFT, FT, LenB(FT))      ' Convert FILETIME To Long
    Get_FILETIME = lngFT
End Function

Public Sub Set_SYSTEMTIME(ByVal lngFT As Long)
    Call Get_FILETIME
    
    ' Retrieve Time
    Call CopyMemory(FT, lngFT, Len(lngFT))      ' Convert Long To FILETIME
    Call FileTimeToLocalFileTime(FT, FT)            ' Convert FILETIME From GMT To Local Time
    Call FileTimeToSystemTime(FT, ST)             ' Convert FILETIME To SYSTEM TIME
    
'Debug.Print Format(ST.wMonth, "00") & "/" & Format(ST.wDay, "00") & "/" & Format(ST.wYear, "0000") & space(1) & _
Format(ST.wHour, "00") & ":" & Format(ST.wMinute, "00") & ":" & Format(ST.wSecond, "00") & "." & Format(ST.wMilliseconds, "000")
End Sub

Public Function Get_Date() As String
    Get_Date = Format(ST.wMonth, "00") & "/" & Format(ST.wDay, "00") & "/" & Format(ST.wYear, "0000")
End Function

Public Function Get_Time() As String
    Get_Time = Format(ST.wHour, "00") & ":" & Format(ST.wMinute, "00") & ":" & Format(ST.wSecond, "00")
End Function


